//Source file: H:\middleware\src\Alkindi\Services\BeanImpl\UserStat.java

package Alkindi.Services.ServicesImpl;

import java.sql.*;
import Alkindi.Services.Util.*;
import Alkindi.Data.SystemUser;
import Alkindi.Services.AlkExcept;

/**
 * Facilitates storage and retrieval of User Statistics. <br>
 * <b>Note:</b>&nbsp;Legacy of original Appian implementation, to be removed in future versions.
 */
class UserStat 
{
	
	/**
	 * @roseuid 3AE858AB02BF
	 */
	public UserStat() 
	{
	}
	
	/**
	 * Returns the number of products the given User has "seen."
	 * 	@param user the user in question
	 * 	@return int
	 * 	@throws AlkExcept
	 * @roseuid 3AE858AB02C0
	 */
	public static final int getNumProdSeen(SystemUser user) throws AlkExcept 
	{
		final String mName = "getNumProdSeen";
		Connection con = null;
		int gnms = 0;
		try
         {
			
			con = AlkConn.getConnection();
			CallableStatement cs = 
				con.prepareCall("{ call pkg_ALKINDI_EVALUATION.sp_CNT_PROD_SEEN_BY_USER(?,?,?)}");  
			cs.setLong(1, user.id);
			cs.registerOutParameter(2, Types.INTEGER );
			cs.registerOutParameter(3, Types.INTEGER );	
			cs.executeQuery();
			int nvalue = cs.getInt(2);
			int error = cs.getInt(3);
			if (error != 0) {
				throw new AlkExcept("", error);
			}
			gnms = nvalue;
		    cs.close();
			
		} //END try

		catch(SQLException se) 		{
			throw new AlkExcept("SQL Exception in " + mName + ": " + se.getMessage(),6004);
		} 
		catch(Exception e) {
			throw new AlkExcept("Exception in " + mName + ": " + e.getMessage(), 3001);
		}
		finally {
			try {
				con.close();
			}
			catch(Exception e) {
			}
		}

		return gnms;
	}
}
